﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WindowsGame1
{
    class GraczAI : Gracz
    {
        public Vector2 predkoscPilki;
        public Vector2 polozeniePilki;
        public bool czyGraczKomputerowy;
        public int odlegloscReakcji;

        public GraczAI(Game game, Texture2D tekstura, Vector2 polozenie, Vector2 rozmiar, Rectangle obszarDozwolony, bool czyGraczKomputerowy)
            : base(game, tekstura, polozenie, rozmiar, obszarDozwolony)
        {
            this.czyGraczKomputerowy = czyGraczKomputerowy;
            this.odlegloscReakcji = 0;
        }

        private bool CzyPilkaSiePrzybliza()
        {
            float d1 = spriteGracza.polozenie.X - polozeniePilki.X;
            if (Math.Abs(d1) > odlegloscReakcji) return false;
            return d1 * predkoscPilki.X > 0;
        }

        public void Graj(float krokCzasowy)
        {
            if (CzyPilkaSiePrzybliza())
            {
                spriteGracza.predkosc.Y = (spriteGracza.polozenie.Y > polozeniePilki.Y) ? -3 : 3;
            }

            spriteGracza.ZmienPolozenie(krokCzasowy);

            spriteGracza.predkosc.Y = 0;
            spriteGracza.predkosc.X = 0;
        }

        public override void Update(GameTime gameTime)
        {
            if (czyGraczKomputerowy)
                Graj((float)gameTime.ElapsedGameTime.TotalMilliseconds / 10);
            else
                Przemieszczanie((float)gameTime.ElapsedGameTime.TotalMilliseconds / 10);
        }
    }
}
